#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_S 200005

int N, Q;
int A[MAX_S];
int C[MAX_S]; 

long long BC[MAX_S]; 
long long BS[MAX_S]; 

void BIT_azuriraj(long long *BIT, int idx, long long delta) {
    for (; idx <= N; idx += idx & (-idx)) {
        BIT[idx] += delta;
    }
}

long long BIT_upit(long long *BIT, int idx) {
    long long suma = 0;
    for (; idx > 0; idx -= idx & (-idx)) {
        suma += BIT[idx];
    }
    return suma;
}

int nadji_k_ti_ukupno(long long k) {
    int l = 1, r = N, ans = N + 1;
    if (k <= 0) return 0;
    
    while (l <= r) {
        int mid = l + (r - l) / 2;
        if (BIT_upit(BC, mid) >= k) {
            ans = mid;
            r = mid - 1;
        } else {
            l = mid + 1;
        }
    }
    return ans;
}

void AzurirajBIT_potpuno(int v, int promena) {
    BIT_azuriraj(BC, v, promena);
    BIT_azuriraj(BS, v, (long long)v * promena);
}

void Izmeni(int x, int y) {
    int sV = A[x];
    int nV = y;

    if (sV == nV) return;

    AzurirajBIT_potpuno(sV, -1);
    C[sV]--;

    AzurirajBIT_potpuno(nV, 1);
    C[nV]++;

    A[x] = y;
}

void Odgovor(int k) {
    long long P = (long long)N - k; 
    
    long long N_neparan = 0;
    for(int v=1; v<=N; v++) {
        if (C[v] % 2 != 0) N_neparan++;
    }

    long long P_parovi = (BIT_upit(BC, N) - N_neparan) / 2;

    long long N_ostaje;
    
    if (P_parovi >= P) {
        N_ostaje = N - 2 * P;
    } else {
        N_ostaje = N - (P + P_parovi);
    }
    
    if (N_ostaje <= 0) {
        printf("0\n");
        return;
    }
    
    long long K_najmanjih = N_ostaje;
    
    int v_max = nadji_k_ti_ukupno(K_najmanjih);
    
    long long S_min = BIT_upit(BS, v_max - 1);
    
    long long Br_do_v_max = BIT_upit(BC, v_max - 1);
    long long Br_potreban_na_v_max = K_najmanjih - Br_do_v_max;
    
    S_min += Br_potreban_na_v_max * v_max;
    
    printf("%lld\n", S_min);
}

int main() {
    if (scanf("%d %d", &N, &Q) != 2) return 1;

    for (int i = 1; i <= N; i++) {
        if (scanf("%d", &A[i]) != 1) return 1;
        
        C[A[i]]++;
        AzurirajBIT_potpuno(A[i], 1);
    }

    for (int i = 0; i < Q; i++) {
        int t;
        if (scanf("%d", &t) != 1) return 1;

        if (t == 1) {
            int k; 
            if (scanf("%d", &k) != 1) return 1;
            Odgovor(k);

        } else if (t == 2) {
            int x, y;
            if (scanf("%d %d", &x, &y) != 2) return 1;
            Izmeni(x, y);
        }
    }

    return 0;
}